/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.pa.fedc;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.pa.fedc.FEDCJavaExecutable;
import com.ibm.hwmca.fw.pa.problem.Problem;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.util.CommonXMLParser;
import com.ibm.hwmca.fw.util.NativeProcess;
import com.ibm.hwmca.fw.util.NativeProcessParameters;
import com.ibm.hwmca.fw.util.RootProcess;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import com.ibm.hwmca.xfw.pa.util.DataPortListener;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FEDCExecutable
implements Runnable {
    private static final String TRACE_MASKT = "XPAFEDCT";
    private static final String TRACE_MASKF = "XPAFEDCF";
    private static final String TRACE_MASKD = "XPAFEDCD";
    private static final int PROGRAM = 1;
    private static final int SHAREDOBJ = 2;
    private static final int JAVA = 3;
    private static final int ROOTPROCESS = 4;
    private static final String DEFAULT_EED_PATH = "eeddirectory";
    int _type = 0;
    public String _executeType;
    public String _name;
    public String _entry;
    public String _parms;
    public Problem _problem;
    private static final Class[] EVENT_SIGNATURE = new Class[]{class$java$lang$String == null ? (class$java$lang$String = FEDCExecutable.class$("java.lang.String")) : class$java$lang$String};
    static /* synthetic */ Class class$java$lang$String;

    public FEDCExecutable(Node node) {
        Trace.trace(TRACE_MASKT, "--> FEDCExecutable.ctor");
        NodeList childList = node.getChildNodes();
        int numChildren = childList.getLength();
        Node child = null;
        for (int i = 0; i < numChildren; ++i) {
            child = childList.item(i);
            if (child.getNodeType() != 1) continue;
            Trace.trace(TRACE_MASKD, "got the child node. stop.");
            break;
        }
        this._executeType = node.getAttributes().getNamedItem("type").getNodeValue().trim();
        Trace.trace(TRACE_MASKD, "execute type is " + this._executeType);
        if (child != null) {
            this._name = child.getAttributes().getNamedItem("name").getNodeValue().trim();
            if (child.getNodeName().toLowerCase().trim().equals("exe")) {
                this._type = 1;
            } else if (child.getNodeName().toLowerCase().trim().equals("dll")) {
                this._type = 2;
                this._entry = child.getAttributes().getNamedItem("entry").getNodeValue().trim();
            } else if (child.getNodeName().toLowerCase().trim().equals("java")) {
                this._type = 3;
            } else if (child.getNodeName().toLowerCase().trim().equals("rootprocess")) {
                this._type = 4;
            }
            Trace.trace(TRACE_MASKD, "the program type is =" + this._type);
            try {
                this._parms = CommonXMLParser.gatherTextContents(child);
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKD, "got an exception");
                Trace.trace(TRACE_MASKD, e);
            }
        }
        Trace.trace(TRACE_MASKT, "<-- FEDCExecutable.ctor");
    }

    public void run() {
        if (this._problem instanceof CommonProblem) {
            int containsDIR;
            PASystem failingSystem;
            int containsMTMS;
            Trace.trace(TRACE_MASKD, "parms are [" + this._parms + "]");
            String mtms = "--MTMS--";
            if (this._parms != null && (containsMTMS = this._parms.indexOf(mtms)) != -1 && (failingSystem = ((CommonProblem)this._problem).getFailingSystem()) != null) {
                String subString = failingSystem.getMachineType() + "-" + failingSystem.getMachineModel() + "/" + failingSystem.getMachineSerial();
                String first = this._parms.substring(0, containsMTMS);
                String last = this._parms.substring(containsMTMS + mtms.length());
                Trace.trace(TRACE_MASKD, "first = " + first);
                Trace.trace(TRACE_MASKD, "last = " + last);
                this._parms = first + subString + last;
                Trace.trace(TRACE_MASKD, "_parms" + this._parms);
            }
            String direct = "--DIRECT--";
            if (this._parms != null && (containsDIR = this._parms.indexOf(direct)) != -1) {
                Trace.trace(TRACE_MASKD, "build the direct sub");
                String filePath = "";
                try {
                    filePath = BaseFileControl.getFilePath(DEFAULT_EED_PATH);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "got an exception. ignore it.");
                    Trace.trace(TRACE_MASKF, e);
                }
                String dirFirst = this._parms.substring(0, containsDIR);
                String dirLast = this._parms.substring(containsDIR + direct.length());
                Trace.trace(TRACE_MASKD, "dir first = " + dirFirst);
                Trace.trace(TRACE_MASKD, "dir last = " + dirLast);
                this._parms = dirFirst + filePath + dirLast;
                Trace.trace(TRACE_MASKD, "_parms" + this._parms);
            }
            if (this._type == 3) {
                Trace.trace(TRACE_MASKD, "got a java object to work with");
                this.runJavaObject();
            } else if (this._type == 2) {
                Trace.trace(TRACE_MASKD, "got a shared object to work with");
                this.runSharedObject();
            } else if (this._type == 1) {
                Trace.trace(TRACE_MASKD, "got a program object to work with");
                this.runProgramObject();
            } else if (this._type == 4) {
                Trace.trace(TRACE_MASKD, "got a program object to work with");
                this.runRootProgramObject();
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("Type=".concat(this._executeType).concat(", Name=").concat(this._name));
        if (this._entry != null) {
            sb.append(", entry=".concat(this._entry));
        }
        if (this._parms != null) {
            sb.append(", parms=".concat(this._parms));
        }
        return sb.toString().trim();
    }

    public void runJavaObject() {
        try {
            Constructor<?> eventConstructor = Class.forName(this._name).getConstructor(EVENT_SIGNATURE);
            Runnable javaObject = (Runnable)eventConstructor.newInstance(this._parms);
            if (javaObject instanceof FEDCJavaExecutable) {
                Trace.trace(TRACE_MASKD, "setting the problem into the executable");
                ((FEDCJavaExecutable)((Object)javaObject)).setProblem(this._problem);
            } else {
                Trace.trace(TRACE_MASKD, "not a FEDCJavaExecutable");
            }
            javaObject.run();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "got Exception");
            Trace.trace(TRACE_MASKD, e);
        }
    }

    public void runSharedObject() {
        try {
            DataPortListener.sendData(65244, this._parms.getBytes(), this._name, this._entry);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "got an exception");
            Trace.trace(TRACE_MASKD, e);
        }
    }

    public int runProgramObject() {
        int rc = 0;
        Trace.trace(TRACE_MASKT, "--> runProgramObject()");
        try {
            int i;
            String[] parmsArray = new String[]{};
            if (this._parms != null) {
                Trace.trace(TRACE_MASKD, "build the parms array");
                parmsArray = this.buildParmString(this._parms);
                Trace.trace(TRACE_MASKD, "done building it");
            }
            String[] cmdArray = new String[parmsArray.length + 1];
            cmdArray[0] = this._name;
            Trace.trace(TRACE_MASKD, "keo >> the cmdarray for " + this._name + "length =" + cmdArray.length);
            for (i = 0; i < parmsArray.length; ++i) {
                cmdArray[i + 1] = parmsArray[i];
            }
            Trace.trace(TRACE_MASKD, "running [" + cmdArray[0] + "]");
            for (i = 1; i < cmdArray.length; ++i) {
                Trace.trace(TRACE_MASKD, "parm [" + i + "] is {" + cmdArray[i] + "}");
            }
            Trace.trace(TRACE_MASKD, "keo >> the cmdarray for " + this._name + "length =" + cmdArray.length);
            for (i = 0; i < parmsArray.length; ++i) {
                cmdArray[i + 1] = parmsArray[i];
            }
            Trace.trace(TRACE_MASKD, "running [" + cmdArray[0] + "]");
            for (i = 1; i < cmdArray.length; ++i) {
                Trace.trace(TRACE_MASKD, "parm [" + i + "] is {" + cmdArray[i] + "}");
            }
            NativeProcess np = NativeProcess.exec(new NativeProcessParameters(cmdArray));
            Trace.trace(TRACE_MASKD, "waiting");
            np.waitFor();
            Trace.trace(TRACE_MASKD, "done waitng");
            rc = np.exitValue();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "got an exception");
            Trace.trace(TRACE_MASKD, e);
        }
        Trace.trace(TRACE_MASKF, "rc = " + rc);
        Trace.trace(TRACE_MASKT, "<-- runProgramObject");
        return rc;
    }

    public void runRootProgramObject() {
        try {
            int i;
            String[] parmsArray = new String[]{};
            if (this._parms != null) {
                Trace.trace(TRACE_MASKD, "build the parms array");
                parmsArray = this.buildParmString(this._parms);
                Trace.trace(TRACE_MASKD, "done building it");
            }
            String[] cmdArray = new String[parmsArray.length + 1];
            cmdArray[0] = this._name;
            Trace.trace(TRACE_MASKD, "keo >> the cmdarray for " + this._name + "length =" + cmdArray.length);
            for (i = 0; i < parmsArray.length; ++i) {
                cmdArray[i + 1] = parmsArray[i];
            }
            Trace.trace(TRACE_MASKD, "running [" + cmdArray[0] + "]");
            for (i = 1; i < cmdArray.length; ++i) {
                Trace.trace(TRACE_MASKD, "parm [" + i + "] is {" + cmdArray[i] + "}");
            }
            Trace.trace(TRACE_MASKD, "run it");
            RootProcess.executeProgram(cmdArray);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "got an exception");
            Trace.trace(TRACE_MASKD, e);
        }
    }

    protected String[] buildParmString(String parms) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(parms, " ");
        while (st.hasMoreElements()) {
            String parm = st.nextToken();
            list.add(parm);
        }
        String[] output = list.toArray(new String[0]);
        return output;
    }

    public static void main(String[] args) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

